///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _CONSOLE_CPP
#define _CONSOLE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define _WIN32_WINNT 0x0500

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <WinCon.h>
#include <ConIO.H>
#include <SQL.H>

#include "../Resources/Resource.H"

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"

#include "../../SharedClasses/CMemPool/CMemPool.H"

#include "Routines.H"
#include "Entry.H"
#include "Console.H"
#include "ConsoleProcs.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HANDLE Console_Thread_Handle = NULL;
DWORD Console_Thread_ID = 0;

_ConIO ConIO;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL WINAPI ConsoleHandlerRoutine(DWORD dwCtrlType)
{
    if(dwCtrlType == CTRL_CLOSE_EVENT)
    {
		return true;
    }

    return FALSE;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool OpenConsole(void)
{
    if(gbConsoleOpen)
        return false;

    if(AllocConsole())
    {
        gbConsoleOpen = true;
        CheckMenuItem(MDI.hMenu, ID_SPECIAL_OPENCONSOLE, MF_BYCOMMAND|MF_CHECKED);

        SetConsoleCtrlHandler(ConsoleHandlerRoutine, TRUE);

        char sConTitle[255];
        sprintf_s(sConTitle, sizeof(sConTitle), "%s [Version: %s]", gsTitleCaption, gsFileVersion);
        SetConsoleTitle(sConTitle);

        ConIO.StdIn  = GetStdHandle(STD_INPUT_HANDLE);
        ConIO.StdOut = GetStdHandle(STD_OUTPUT_HANDLE);
        ConIO.StdErr = GetStdHandle(STD_ERROR_HANDLE);

        Console_Thread_Handle = CreateThread(NULL, 0, Console_Thread, (LPVOID)0, 0,&Console_Thread_ID);
        return true;
    }
    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CloseConsole(void)
{
    if(!gbConsoleOpen)
        return false;

    if(FreeConsole())
    {
        CloseHandle(Console_Thread_Handle);
        CloseHandle(ConIO.StdIn);
        CloseHandle(ConIO.StdOut);
        CloseHandle(ConIO.StdErr);

        gbConsoleOpen = false;
        CheckMenuItem(MDI.hMenu, ID_SPECIAL_OPENCONSOLE, MF_BYCOMMAND|MF_UNCHECKED);
        return true;
    }
    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL WriteConEx(char *Buffer, int Length)
{
    DWORD NumberOfBytesWritten = 0;
    return WriteFile(ConIO.StdOut, Buffer, Length, &NumberOfBytesWritten, 0);;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL WriteCon(char *Buffer)
{
    return WriteConEx(Buffer, strlen(Buffer));
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD GetConsoleInput(char *RetBuffer, int MaxLength)
{
    DWORD NumberOfBytesRead = 0;
    ReadFile(ConIO.StdIn, RetBuffer, MaxLength, &NumberOfBytesRead, 0);
    NumberOfBytesRead = (NumberOfBytesRead - 2);
    if(NumberOfBytesRead > 0)
    {
        RetBuffer[NumberOfBytesRead] = '\0';
        return NumberOfBytesRead;
    }
    return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Console_Thread(LPVOID lpData)
{
    char Command[1025];

    WriteCon("Core:> ");
    while(1)
    {
        int CommandLen = GetConsoleInput(Command, 1024);
        if(CommandLen > 0)
        {
            int Result = ProcessConsoleCoreCommand(Command);
            if(Result == CONSOLE_CORE_RES_CLOSE)
            {
                CloseConsole();
                return 0;
            }
            WriteCon("\nCore:> ");
        }
        else WriteCon("Core:> ");
        Sleep(1);
    }

	return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
